<?php
/**
 * Companies Controller
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
use libraries\BaseController;

class Companies extends BaseController {

	/**
	 * Constructor CodeIgniter
	 */
	public function __construct() {
		parent::__construct();
		$this->auth->check_auth();

		// load model
		$this->load->model('Companies_model');
	}

	public function index() {
		$data['content_title'] = 'Perusahaan';
		
		if(check_roles('1') or check_roles('2')){
			$this->twiggy_display('adm/companies/index', $data);
		}else{
			redirect("Error");
		}
	}

	public function get_data() {
		$data = [];
		$get_data = $this->Companies_model->get_data()->result();

		if($get_data) {
			$no=1;
			foreach($get_data as $get_row) {
				$data[] = array(
					'no'        => $no,
					'id'        => $get_row->company_id,
					'name'      => $get_row->company_name,
					'telephone' => $get_row->company_telephone,
					'email'     => $get_row->company_email,
					'address'   => $get_row->company_address
				);
			$no++;
			}
		}

		$response = [ 
			'data'         => $data,
			'recordsTotal' => count($data)
		];

		output_json($response);
	}

	public function edit($id='new') {
		$title    = "Tambah";
		$get_data = array();

		if($id != 'new') {
			$title    = "Edit";
			$get_data = $this->Companies_model->get_data($id)->row_array();
		}

		$data['id']            = $id;
		$data['content_title'] = $title;
		$data['get_data']      = $get_data;

		$this->twiggy_display('adm/companies/edit', $data);
	}

	public function save() {
		// post
		$id        = $this->input->post('id');
		$name      = $this->input->post('name');
		$telephone = $this->input->post('telephone');
		$email     = $this->input->post('email');
		$address   = $this->input->post('address');
		$action    = $this->input->post('action');

		$data_save = array(
			'company_name'      => $name,
			'company_telephone' => $telephone,
			'company_email'     => $email,
			'company_address'   => $address,
		);

		if($id == 'new') {
			$convert = convert_button($action, $id);
			$save = $this->Companies_model->save($data_save);
		} else {
			$convert = convert_button($action, $id);
			$save = $this->Companies_model->update($id, $data_save);
		}

		if($save) {
			$response = array(
				'status'  => 'success',
				'message' => 'Berhasil menyimpan data',
				'id'      => $convert
			);
		}

		else {
			$response = array(
				'status'  => 'error',
				'message' => 'Gagal menyimpan data',
				'id'      => $convert
			);
		}

		output_json($response);
	}

	public function delete() {
		$id = $this->input->post('id');

		foreach($id as $row) {
			$delete_type = $this->Companies_model->delete($row);
		}

		$response = array(
			'message' => 'Berhasil menghapus data',
			'status'  => 'success'
		);

		output_json($response);
	}

	public function check_id() {
		$name  = $this->input->post('id');
		$where = array('company_name' => $name);

		$check = $this->Companies_model->check_id($where);

		if ($check) {
			$response = array('status' => true);
		} else {
			$response = array('status' => false);
		}

		output_json($response);
	}

}

?>
